/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.client.commands;

import com.dodgeman.shw.client.commands.CommandLineFormatter;
import com.dodgeman.shw.config.ShwConfigWrapper;
import com.dodgeman.shw.saveddata.SetHomeAndWaypointsSavedData;
import com.dodgeman.shw.saveddata.SetHomeWaypointsSavedDataFactory;
import com.dodgeman.shw.saveddata.mappers.PositionMapper;
import com.dodgeman.shw.saveddata.models.PlayerHomeAndWaypoints;
import com.dodgeman.shw.saveddata.models.ValueObject;
import com.dodgeman.shw.saveddata.models.Waypoint;
import com.dodgeman.shw.saveddata.models.WaypointName;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class WaypointsCommand {
    public static final String COMMAND_NAME = "wp";
    public static final long TIME_BEFORE_SHOWING_UNDO_REMINDER = 86400000L;
    public static final long TIME_BEFORE_SHOWING_UNDO_INFORMATION = 86400000L;
    public static final int NB_REMOVE_WAYPOINT_SUCCESS_MESSAGE = 4;
    public static final String COMMAND_SET_NAME = "set";
    public static final String COMMAND_USE_NAME = "use";
    public static final String COMMAND_UPDATE_NAME = "update";
    public static final String COMMAND_LIST_NAME = "list";
    public static final String COMMAND_REMOVE_NAME = "remove";
    public static final String COMMAND_CLEAR_NAME = "clear";
    public static final String COMMAND_UNDO_NAME = "undo";
    public static final String COMMAND_CONFIG_NAME = "config";
    public static final String ARG_NAME_FOR_WAYPOINT_NAME = "waypoint name";
    public static final int SET_MAXIMUM_WAYPOINTS_REACHED_FAILURE = -1;
    public static final int SET_DUPLICATE_WAYPOINT_NAME_FAILURE = -2;
    public static final int USE_TRAVEL_THROUGH_DIMENSION_FAILURE = -1;
    public static final int USE_COOLDOWN_NOT_READY_FAILURE = -2;
    public static final int USE_WAYPOINT_NOT_FOUND_FAILURE = -3;
    public static final int UPDATE_WAYPOINT_NOT_FOUND_FAILURE = -1;
    public static final int DELETE_WAYPOINT_NOT_FOUND_FAILURE = -1;
    public static final int UNDO_LAST_DELETED_WAYPOINT_FAILURE = -1;
    public static final String COMMAND_COOLDOWN_NAME = "cooldown";
    public static final String ARG_NAME_FOR_COOLDOWN = "cooldownValue";
    public static final String COMMAND_DIMENSIONAL_TRAVEL_NAME = "dimensionalTravel";
    public static final String ARG_NAME_FOR_DIMENSIONAL_TRAVEL = "dimensionalTravelValue";
    public static final String ARG_NAME_FOR_MAX_WAYPOINTS = "max number of waypoints";
    public static final String COMMAND_MAX_WAYPOINTS_NAME = "maximumWaypointsNumber";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_NAME).requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)COMMAND_SET_NAME).then(Commands.m_82129_((String)ARG_NAME_FOR_WAYPOINT_NAME, (ArgumentType)StringArgumentType.word()).executes(WaypointsCommand::setWaypoint)))).then(Commands.m_82127_((String)COMMAND_USE_NAME).then(Commands.m_82129_((String)ARG_NAME_FOR_WAYPOINT_NAME, (ArgumentType)StringArgumentType.word()).suggests(WaypointsCommand.getWaypointsNameSuggestion()).executes(WaypointsCommand::useWaypoint)))).then(Commands.m_82127_((String)COMMAND_UPDATE_NAME).then(Commands.m_82129_((String)ARG_NAME_FOR_WAYPOINT_NAME, (ArgumentType)StringArgumentType.word()).suggests(WaypointsCommand.getWaypointsNameSuggestion()).executes(WaypointsCommand::updateWaypoint)))).then(Commands.m_82127_((String)COMMAND_LIST_NAME).executes(WaypointsCommand::listWaypoints))).then(Commands.m_82127_((String)COMMAND_REMOVE_NAME).then(Commands.m_82129_((String)ARG_NAME_FOR_WAYPOINT_NAME, (ArgumentType)StringArgumentType.word()).suggests(WaypointsCommand.getWaypointsNameSuggestion()).executes(WaypointsCommand::removeWaypoint)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_CLEAR_NAME).executes(WaypointsCommand::clearWaypoints)).requires(CommandSourceStack::m_230897_))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_UNDO_NAME).executes(WaypointsCommand::undoDeletedWaypoint)).requires(CommandSourceStack::m_230897_))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_CONFIG_NAME).executes(WaypointsCommand::showConfiguration)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_COOLDOWN_NAME).requires(stack -> stack.m_6761_(3))).then(Commands.m_82129_((String)ARG_NAME_FOR_COOLDOWN, (ArgumentType)IntegerArgumentType.integer((int)0)).executes(WaypointsCommand::configureCooldown)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_DIMENSIONAL_TRAVEL_NAME).requires(stack -> stack.m_6761_(3))).then(Commands.m_82129_((String)ARG_NAME_FOR_DIMENSIONAL_TRAVEL, (ArgumentType)BoolArgumentType.bool()).executes(WaypointsCommand::configureDimensionalTravel)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_MAX_WAYPOINTS_NAME).requires(stack -> stack.m_6761_(3))).then(Commands.m_82129_((String)ARG_NAME_FOR_MAX_WAYPOINTS, (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(WaypointsCommand::configureMaxNbOfWaypoints)))));
    }

    public static SuggestionProvider<CommandSourceStack> getWaypointsNameSuggestion() {
        return (context, builder) -> SharedSuggestionProvider.m_82981_(new SetHomeWaypointsSavedDataFactory().createAndLoad().getPlayerHomeAndWaypoints(((CommandSourceStack)context.getSource()).m_81375_().m_20148_()).getWaypointsName().stream().map(ValueObject::value), (SuggestionsBuilder)builder);
    }

    public static int setWaypoint(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean playerHasReachMaximumWaypoints;
        WaypointName waypointName = new WaypointName(StringArgumentType.getString(context, (String)ARG_NAME_FOR_WAYPOINT_NAME));
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        if (playerHomeAndWaypoints.hasWaypointNamed(waypointName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.set.error.duplicateWaypoint", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName)}));
            return -2;
        }
        boolean bl = playerHasReachMaximumWaypoints = playerHomeAndWaypoints.getNbOfWaypoints() >= ShwConfigWrapper.getMaxNbOfWaypoints();
        if (playerHasReachMaximumWaypoints) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.set.error.maximumNumberOfWaypoints", (Object[])new Object[]{ShwConfigWrapper.getMaxNbOfWaypoints()}));
            return -1;
        }
        MutableComponent successMessage = null;
        if (!playerHomeAndWaypoints.hasAlreadySetWaypoint()) {
            successMessage = Component.m_237110_((String)"shw.commands.waypoints.set.success.first_waypoint", (Object[])new Object[]{CommandLineFormatter.formatCommand(COMMAND_NAME, COMMAND_USE_NAME, (String)waypointName.value())}).m_130940_(ChatFormatting.GREEN);
        }
        Waypoint lastDeletedWaypoint = playerHomeAndWaypoints.getLastDeletedWaypoint();
        playerHomeAndWaypoints.addWaypoint(new Waypoint(waypointName, PositionMapper.fromPlayer(player)));
        if (successMessage == null) {
            successMessage = Component.m_237110_((String)"shw.commands.waypoints.set.success", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName), CommandLineFormatter.formatNbOfWaypoints(playerHomeAndWaypoints.getNbOfWaypoints(), ShwConfigWrapper.getMaxNbOfWaypoints())}).m_130940_(ChatFormatting.GREEN);
        }
        ((CommandSourceStack)context.getSource()).m_81354_(successMessage, false);
        long lastTimeUndoInformation = new Date().getTime() - playerHomeAndWaypoints.getUndoInformationHasBeenShownAt();
        if (lastDeletedWaypoint != null && lastTimeUndoInformation >= 86400000L) {
            playerHomeAndWaypoints.undoInformationHasBeenShown();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.set.info.undo", (Object[])new Object[]{CommandLineFormatter.formatWaypointItalic(waypointName), CommandLineFormatter.formatWaypointItalic(lastDeletedWaypoint.name())}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC), false);
        }
        savedData.m_77762_();
        return 1;
    }

    public static int useWaypoint(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        WaypointName waypointName = new WaypointName(StringArgumentType.getString(context, (String)ARG_NAME_FOR_WAYPOINT_NAME));
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        Waypoint waypoint = playerHomeAndWaypoints.getWaypointByName(waypointName);
        if (waypoint == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.use.error.waypointNotFound", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName)}));
            return -3;
        }
        ServerLevel serverLevel = player.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(waypoint.position().dimension())));
        if (!ShwConfigWrapper.isDimensionalTravelAllowedForWaypoints() && !player.m_9236_().m_46472_().equals((Object)serverLevel.m_46472_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"shw.commands.waypoints.use.error.dimensionalTravelNotAllowed"));
            return -1;
        }
        long cooldownRemaining = TimeUnit.SECONDS.toMillis(ShwConfigWrapper.getWaypointsCooldown()) - playerHomeAndWaypoints.elapsedTimeOfWaypointUseCommandExecution();
        if (cooldownRemaining > 0L) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.use.error.cooldown", (Object[])new Object[]{TimeUnit.MILLISECONDS.toSeconds(cooldownRemaining) + 1L, CommandLineFormatter.formatWaypoint(waypointName)}));
            return -2;
        }
        Waypoint lastDeletedWaypoint = playerHomeAndWaypoints.getLastDeletedWaypoint();
        playerHomeAndWaypoints.waypointUseCommandHasBeenExecuted();
        player.m_8999_(serverLevel, waypoint.position().x(), waypoint.position().y(), waypoint.position().z(), waypoint.position().ry(), waypoint.position().rx());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.use.success", (Object[])new Object[]{waypointName.value()}), false);
        long elapsedTimeOfLastUndoInfo = new Date().getTime() - playerHomeAndWaypoints.getUndoInformationHasBeenShownAt();
        if (lastDeletedWaypoint != null && elapsedTimeOfLastUndoInfo >= 86400000L) {
            playerHomeAndWaypoints.undoInformationHasBeenShown();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.use.info.undo", (Object[])new Object[]{CommandLineFormatter.formatWaypointItalic(waypointName), CommandLineFormatter.formatWaypointItalic(lastDeletedWaypoint.name())}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC), false);
        }
        savedData.m_77762_();
        return 1;
    }

    public static int updateWaypoint(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        WaypointName waypointName = new WaypointName(StringArgumentType.getString(context, (String)ARG_NAME_FOR_WAYPOINT_NAME));
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        if (!playerHomeAndWaypoints.hasWaypointNamed(waypointName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.update.error.waypointNotFound", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName)}));
            return -1;
        }
        Waypoint lastDeletedWaypoint = playerHomeAndWaypoints.getLastDeletedWaypoint();
        playerHomeAndWaypoints.addWaypoint(new Waypoint(waypointName, PositionMapper.fromPlayer(player)));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.update.success", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName)}).m_130940_(ChatFormatting.GREEN), false);
        long elapsedTimeOfLastUndoInfo = new Date().getTime() - playerHomeAndWaypoints.getUndoInformationHasBeenShownAt();
        if (lastDeletedWaypoint != null && elapsedTimeOfLastUndoInfo >= 86400000L) {
            playerHomeAndWaypoints.undoInformationHasBeenShown();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.update.info.undo", (Object[])new Object[]{CommandLineFormatter.formatWaypointItalic(waypointName), CommandLineFormatter.formatWaypointItalic(lastDeletedWaypoint.name())}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC), false);
        }
        savedData.m_77762_();
        return 1;
    }

    public static int listWaypoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        List<WaypointName> waypointsName = playerHomeAndWaypoints.getWaypointsName();
        MutableComponent successMessage = Component.m_237113_((String)"/wp use [ ");
        int nbOfWaypoints = waypointsName.size();
        for (int i = 0; i < nbOfWaypoints; ++i) {
            successMessage.m_7220_((Component)CommandLineFormatter.formatWaypoint(waypointsName.get(i)));
            if (i >= nbOfWaypoints - 1) continue;
            successMessage.m_130946_(", ");
        }
        successMessage.m_130946_(" ] ").m_7220_((Component)CommandLineFormatter.formatNbOfWaypoints(waypointsName.size(), ShwConfigWrapper.getMaxNbOfWaypoints()));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)successMessage, false);
        return 1;
    }

    public static int removeWaypoint(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        WaypointName waypointName = new WaypointName(StringArgumentType.getString(context, (String)ARG_NAME_FOR_WAYPOINT_NAME));
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        if (!playerHomeAndWaypoints.hasWaypointNamed(waypointName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.waypoints.remove.error.waypointNotFound", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName)}));
            return -1;
        }
        long lastTimeDeletedWaypoint = playerHomeAndWaypoints.getLastDeletedWaypointAt();
        playerHomeAndWaypoints.removeWaypoint(waypointName);
        int successMessageIndex = playerHomeAndWaypoints.getRemoveWaypointSuccessMessageIndex();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)("shw.commands.waypoints.remove.success." + successMessageIndex), (Object[])new Object[]{CommandLineFormatter.formatWaypoint(waypointName), CommandLineFormatter.formatWaypoint(waypointName)}), false);
        playerHomeAndWaypoints.updateRemoveWaypointSuccessMessageIndex(4);
        long elapsedTimeOfLastUndo = new Date().getTime() - lastTimeDeletedWaypoint;
        if (elapsedTimeOfLastUndo >= 86400000L || lastTimeDeletedWaypoint == 0L) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.remove.info.undo", (Object[])new Object[]{CommandLineFormatter.formatWaypointItalic(waypointName), CommandLineFormatter.formatCommand(COMMAND_NAME, COMMAND_UNDO_NAME)}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC), false);
        }
        savedData.m_77762_();
        return 1;
    }

    public static int clearWaypoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"shw.commands.waypoints.clear.success"), false);
        playerHomeAndWaypoints.clearWaypoints();
        savedData.m_77762_();
        return 1;
    }

    public static int undoDeletedWaypoint(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        if (!playerHomeAndWaypoints.hasLastDeletedWaypoint()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"shw.commands.waypoints.undo.error.noLastWaypointDeletedFound"));
            return -1;
        }
        Waypoint lastDeletedWaypoint = playerHomeAndWaypoints.getLastDeletedWaypoint();
        playerHomeAndWaypoints.undoLastDeletedWaypoint();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.undo.success", (Object[])new Object[]{CommandLineFormatter.formatWaypoint(lastDeletedWaypoint.name())}).m_130940_(ChatFormatting.GREEN), false);
        savedData.m_77762_();
        return 1;
    }

    public static int showConfiguration(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.waypoints.config.success", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(ShwConfigWrapper.getWaypointsCooldown())).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)String.valueOf(ShwConfigWrapper.getMaxNbOfWaypoints())).m_130940_(ChatFormatting.BLUE), CommandLineFormatter.formatPermitted(ShwConfigWrapper.isDimensionalTravelAllowedForWaypoints())}), false);
        return 1;
    }

    public static int configureCooldown(CommandContext<CommandSourceStack> context) {
        int cooldownValue = IntegerArgumentType.getInteger(context, (String)ARG_NAME_FOR_COOLDOWN);
        ShwConfigWrapper.setWaypointsCooldown(cooldownValue);
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            player.m_213846_((Component)Component.m_237110_((String)"shw.commands.waypoints.config.cooldown.success", (Object[])new Object[]{CommandLineFormatter.formatCommand(COMMAND_NAME, COMMAND_USE_NAME), Component.m_237113_((String)String.valueOf(cooldownValue))}).m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }

    public static int configureDimensionalTravel(CommandContext<CommandSourceStack> context) {
        boolean dimensionalTravel = BoolArgumentType.getBool(context, (String)ARG_NAME_FOR_DIMENSIONAL_TRAVEL);
        ShwConfigWrapper.setAllowDimensionalTravelForWaypoints(dimensionalTravel);
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            player.m_213846_((Component)Component.m_237110_((String)"shw.commands.waypoints.config.dimensionalTravel.success", (Object[])new Object[]{CommandLineFormatter.formatCommand(COMMAND_NAME, COMMAND_USE_NAME), Component.m_237113_((String)String.valueOf(dimensionalTravel))}).m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }

    public static int configureMaxNbOfWaypoints(CommandContext<CommandSourceStack> context) {
        int maxNbOfWaypoints = IntegerArgumentType.getInteger(context, (String)ARG_NAME_FOR_MAX_WAYPOINTS);
        ShwConfigWrapper.setMaxNbOfWaypoints(maxNbOfWaypoints);
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            player.m_213846_((Component)Component.m_237110_((String)"shw.commands.waypoints.config.maximumNumberOfWaypoints.success", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(maxNbOfWaypoints))}).m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }
}

